<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('/superadmin', 'Supercontroller::index');

$routes->group('admin', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('home', 'Admin\Home::index');
});

$routes->group('operator', ['filter' => 'group:operator'], static function ($routes) {
    $routes->get('home', 'Operator\Home::index');
});

$routes->group('waiter', ['filter' => 'group:waiter'], static function ($routes) {
    $routes->get('home', 'Waiter\Home::index');
});

$routes->group('meja', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('/', 'Meja::index');
    $routes->post('ajax_dt', 'Meja::ajax_dt');
    $routes->get('add', 'Meja::add');
    $routes->post('add_save', 'Meja::add_save');
    $routes->get('view/(:any)', 'Meja::view/$1');
    $routes->post('update', 'Meja::update');
    $routes->post('delete', 'Meja::delete');
});

$routes->group('produk', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('/', 'Produk::index');
    $routes->post('ajax_dt', 'Produk::ajax_dt');
    $routes->get('add', 'Produk::add');
    $routes->post('add_save', 'Produk::add_save');
    $routes->get('view/(:any)', 'Produk::view/$1');
    $routes->post('update', 'Produk::update');
    $routes->post('delete', 'Produk::delete');

    $routes->post('upload', 'Produk::upload');
});

$routes->group('harga', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('/', 'Harga::index');
    $routes->post('ajax_dt', 'Harga::ajax_dt');
    
    $routes->get('detail/(:any)', 'Harga::detail/$1');
    $routes->post('ajax_dt_detail/(:any)', 'Harga::ajax_dt_detail/$1');
    $routes->get('add/(:any)', 'Harga::add/$1');
    $routes->post('add_save', 'Harga::add_save');
    $routes->get('view/(:any)', 'Harga::view/$1');
    $routes->post('update', 'Harga::update');
    $routes->post('delete', 'Harga::delete');
});

$routes->group('pajak', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('/', 'Pajak::index');
    $routes->post('ajax_dt', 'Pajak::ajax_dt');
    $routes->get('add', 'Pajak::add');
    $routes->post('add_save', 'Pajak::add_save');
    $routes->get('view/(:any)', 'Pajak::view/$1');
    $routes->post('update', 'Pajak::update');
    $routes->post('delete', 'Pajak::delete');
});

$routes->group('order', ['filter' => 'group:admin, operator, waiter'], static function ($routes) {
    $routes->get('/', 'Order::index');
    $routes->get('pesanan/(:any)', 'Order::pesanan/$1');
    $routes->get('list_products', 'Order::list_products');
    $routes->post('save_order', 'Order::save_order');
    $routes->post('cancel_order', 'Order::cancel_order');
    $routes->get('checkout/(:any)', 'Order::checkout/$1');
    $routes->get('get_order_items/(:any)', 'Order::get_order_items/$1');
    $routes->post('checkout_submit', 'Order::checkout_submit');
    $routes->get('print_struk/(:any)', 'Order::print_struk/$1');
    $routes->post('cancel_transaksi', 'Order::cancel_transaksi');

    $routes->get('riwayat', 'Order::riwayat');
    $routes->post('ajax_dt', 'Order::ajax_dt');
    $routes->get('view_riwayat/(:any)', 'Order::view_riwayat/$1');
});

$routes->group('takeaway', ['filter' => 'group:admin, operator'], static function ($routes) {
    $routes->get('/', 'Takeaway::index');
    $routes->post('ajax_dt', 'Takeaway::ajax_dt');
    $routes->get('add', 'Takeaway::add');
    $routes->post('add_save', 'Takeaway::add_save');
    $routes->get('pesanan/(:any)', 'Takeaway::pesanan/$1');
    $routes->get('list_products', 'Takeaway::list_products');
    $routes->post('save_order', 'Takeaway::save_order');
    $routes->post('cancel_order', 'Takeaway::cancel_order');
    $routes->get('checkout/(:any)', 'Takeaway::checkout/$1');
    $routes->get('get_order_items/(:any)', 'Takeaway::get_order_items/$1');
    $routes->post('checkout_submit', 'Takeaway::checkout_submit');
    $routes->get('print_struk/(:any)', 'Takeaway::print_struk/$1');
    $routes->post('cancel_transaksi', 'Takeaway::cancel_transaksi');

    $routes->get('riwayat', 'Takeaway::riwayat');
    $routes->post('ajax_dt', 'Takeaway::ajax_dt');
    $routes->get('view_riwayat/(:any)', 'Takeaway::view_riwayat/$1');
});

$routes->group('belanja', ['filter' => 'group:admin, operator'], static function ($routes) {
    $routes->get('/', 'Belanja::index');
    $routes->post('ajax_dt', 'Belanja::ajax_dt');
    $routes->get('add', 'Belanja::add');
    $routes->post('add_save', 'Belanja::add_save');
    $routes->get('view/(:any)', 'Belanja::view/$1');
    $routes->post('update', 'Belanja::update');
    $routes->post('delete', 'Belanja::delete');
});

$routes->group('laporan', ['filter' => 'group:admin, operator'], static function ($routes) {
    $routes->get('transaksi_harian', 'Laporan::transaksi_harian');
    $routes->get('transaksi_harian_proses', 'Laporan::transaksi_harian_proses');
    $routes->get('transaksi_harian_proses_excel', 'Laporan::transaksi_harian_proses_excel');
    $routes->get('metode_penerimaan', 'Laporan::metode_penerimaan');
    $routes->get('metode_penerimaan_proses', 'Laporan::metode_penerimaan_proses');
    $routes->get('metode_penerimaan_proses_excel', 'Laporan::metode_penerimaan_proses_excel');
    $routes->get('belanja_harian', 'Laporan::belanja_harian');
    $routes->get('belanja_harian_proses', 'Laporan::belanja_harian_proses');
    $routes->get('belanja_harian_proses_excel', 'Laporan::belanja_harian_proses_excel');
    $routes->get('laba_rugi', 'Laporan::laba_rugi');
    $routes->get('laba_rugi_proses', 'Laporan::laba_rugi_proses');
    $routes->get('laba_rugi_proses_excel', 'Laporan::laba_rugi_proses_excel');
});

$routes->group('pengguna', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('/', 'Pengguna::index');
    $routes->post('ajax_dt', 'Pengguna::ajax_dt');
    $routes->get('add', 'Pengguna::add');
    $routes->post('add_save', 'Pengguna::add_save');
    $routes->get('view/(:any)', 'Pengguna::view/$1');
    $routes->post('update', 'Pengguna::update');
    $routes->post('delete', 'Pengguna::delete');
});

$routes->group('profile', ['filter' => 'group:admin,operator,waiter'], static function ($routes) {
    $routes->get('/', 'Profile::index');
    $routes->post('update', 'Profile::update');
});

service('auth')->routes($routes);
