<?php
namespace App\Controllers;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Libraries\Pluploadhandler;

use CodeIgniter\API\ResponseTrait;
use App\Models\Belanjamodel;

class Belanja extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/belanja/index',$data);
    }

    public function ajax_dt(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Belanjamodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function add() {
        $data['user'] = $this->user->data;

        return view('admin/belanja/add',$data);
    }

    public function add_save()
    {
        $data = array();
        $data['status'] = 'success';
        $user = $this->user->data;

        $request = [
            'tanggal' => $this->request->getPost('tanggal',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'nominal' => $this->request->getPost('nominal',FILTER_SANITIZE_ADD_SLASHES)
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('tanggal', 'Tanggal', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Belanjamodel();
            $tmodel->db->transBegin();
            $request['id_operator'] = $user->id_user;

            $id = $tmodel->insert($request);
            if($tmodel->db->transStatus() === false){
                $tmodel->db->transRollback();
                return $this->fail($tmodel->errors(),400,null,'db');
            }else{
                $tmodel->db->transCommit();
                return $this->respond($data,200);
            }
        }
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Belanjamodel();
        $builder = $tmodel->builder();
        $data['data'] = $builder->where("id_belanja",$id)->get()->getRow();

        return view('admin/belanja/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';
        $user = $this->user->data;

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'tanggal' => $this->request->getPost('tanggal',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'nominal' => $this->request->getPost('nominal',FILTER_SANITIZE_ADD_SLASHES)
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('tanggal', 'Tanggal', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Belanjamodel();
            $tmodel->db->transBegin();
            $request['id_operator'] = $user->id_user;

            $tmodel->update($id,$request);
            if($tmodel->db->transStatus() === false){
                $tmodel->db->transRollback();
                return $this->fail($tmodel->errors(),400,null,'db');
            }else{
                $tmodel->db->transCommit();
                return $this->respond($data,200);
            }
        }
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Belanjamodel();
        $tmodel->db->transBegin();
        $tmodel->delete($id);
        if ($tmodel->db->transStatus() == true)
        {
            $tmodel->db->transCommit();
            return $this->respond($data,200);
        }else{
            $tmodel->db->transRollback();
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>