<?php
namespace App\Controllers;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Libraries\Pluploadhandler;

use CodeIgniter\API\ResponseTrait;
use App\Models\Produkmodel;
use App\Models\Hargamodel;

class Harga extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/harga/index',$data);
    }

    public function ajax_dt(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Produkmodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function detail($id){
        $data['user'] = $this->user->data;
        $tmodel = new Produkmodel();
        $builder = $tmodel->builder("vproduk");
        $data['produk'] = $builder->where("id_produk",$id)->get()->getRow();

        return view('admin/harga/detail',$data);
    }

    public function ajax_dt_detail($id){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Hargamodel();
        return $DataModel->GetDT($data_post,"(id_produk = $id)");
    }

    public function add($id) {
        $data['user'] = $this->user->data;
        $produkmodel = new Produkmodel();
        $builder = $produkmodel->builder("vproduk");
        $data['produk'] = $builder->where("id_produk",$id)->get()->getRow();

        return view('admin/harga/add',$data);
    }

    public function add_save()
    {
        $data = array();
        $data['status'] = 'success';

        $request = [
            'id_produk' => $this->request->getPost('id_produk',FILTER_SANITIZE_ADD_SLASHES),
            'harga_modal' => $this->request->getPost('harga_modal',FILTER_SANITIZE_ADD_SLASHES),
            'harga_jual' => $this->request->getPost('harga_jual',FILTER_SANITIZE_ADD_SLASHES),
            'aktif' => $this->request->getPost('aktif',FILTER_SANITIZE_ADD_SLASHES)
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('id_produk', 'Produk', 'required');
        $validation->setRule('harga_jual', 'Harga Jual', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Hargamodel();
            $tmodel->db->transBegin();
            $id = $tmodel->insert($request);
            if($tmodel->db->transStatus() === false){
                $tmodel->db->transRollback();
                return $this->fail($tmodel->errors(),400,null,'db');
            }else{
                $tmodel->db->transCommit();
                return $this->respond($data,200);
            }
        }
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Hargamodel();
        $builder = $tmodel->builder();
        $data['data'] = $builder->where("id_harga",$id)->get()->getRow();

        $produkmodel = new Produkmodel();
        $builder2 = $produkmodel->builder("vproduk");
        $data['produk'] = $builder2->where("id_produk",$data['data']->id_produk)->get()->getRow();
        return view('admin/harga/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'harga_modal' => $this->request->getPost('harga_modal',FILTER_SANITIZE_ADD_SLASHES),
            'harga_jual' => $this->request->getPost('harga_jual',FILTER_SANITIZE_ADD_SLASHES),
            'aktif' => $this->request->getPost('aktif',FILTER_SANITIZE_ADD_SLASHES)
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('harga_jual', 'Harga Jual', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Hargamodel();
            $tmodel->db->transBegin();
            $tmodel->update($id,$request);
            if($tmodel->db->transStatus() === false){
                $tmodel->db->transRollback();
                return $this->fail($tmodel->errors(),400,null,'db');
            }else{
                $tmodel->db->transCommit();
                return $this->respond($data,200);
            }
        }
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Hargamodel();
        $tmodel->db->transBegin();
        $tmodel->delete($id);
        if ($tmodel->db->transStatus() == true)
        {
            $tmodel->db->transCommit();
            return $this->respond($data,200);
        }else{
            $tmodel->db->transRollback();
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>