<?php

namespace App\Controllers\Operator;

use App\Controllers\BaseController;
use App\Controllers\Meja;
use App\Models\Transaksimodel;
use App\Models\Transaksitakeawaymodel;
use App\Models\Ordermodel;
use App\Models\Takeawaymodel;
use App\Models\Mejamodel;
use App\Models\Belanjamodel;

class Home extends BaseController
{
    private $user;
    
    public function index(): string
    {
        $this->user = service("user_data"); 
        $data['user'] = $this->user->data;

        $income = [
            "channel" => [
                "ditempat" => [
                    "count" => 0,
                    "total" => 0,
                ],
                "takeaway" => [
                    "count" => 0,
                    "total" => 0,
                ],
            ],
            "payment" => [
                "cash" => [
                    "count" => 0,
                    "total" => 0
                ],
                "qris" => [
                    "count" => 0,
                    "total" => 0
                ],
                "debit" => [
                    "count" => 0,
                    "total" => 0
                ],
                "lainnya" => [
                    "count" => 0,
                    "total" => 0
                ],
            ]
        ];
        
        $order_open = 0;
        $takeaway_open = 0;
        $meja = [
            "terisi" => 0,
            "kosong" => 0
        ];
        $spend_today = 0;

        $now = date('Y-m-d');

        $transaksimodel = new Transaksimodel();
        $builder = $transaksimodel->builder("vtransaksi");
        $builder->select('metode, COUNT(*) as trx, SUM(grand_total) as total_nominal');
        $builder->where('status', "closed");
        $builder->where('tanggal_order >=', $now.' 00:00:00');
        $builder->where('tanggal_order <',  $now.' 23:59:59');
        $builder->groupBy('metode');
        $result = $builder->get()->getResult();
        foreach($result as $rs){
            $income['payment'][$rs->metode]['count'] += $rs->trx;
            $income['payment'][$rs->metode]['total'] += $rs->total_nominal; 

            $income['channel']["ditempat"]['count'] += $rs->trx;
            $income['channel']["ditempat"]['total'] += $rs->total_nominal;
        }

        $transaksitakeawaymodel = new Transaksitakeawaymodel();
        $builder = $transaksitakeawaymodel->builder("vtransaksitakeaway");
        $builder->select('metode, COUNT(*) as trx, SUM(grand_total) as total_nominal');
        $builder->where('status', "closed");
        $builder->where('tanggal >=', $now.' 00:00:00');
        $builder->where('tanggal <',  $now.' 23:59:59');
        $builder->groupBy('metode');
        $result = $builder->get()->getResult();
        foreach($result as $rs){
            $income['payment'][$rs->metode]['count'] += $rs->trx;
            $income['payment'][$rs->metode]['total'] += $rs->total_nominal; 

            $income['channel']["takeaway"]['count'] += $rs->trx;
            $income['channel']["takeaway"]['total'] += $rs->total_nominal;
        }

        
        $ordermodel = new Ordermodel();
        $builder = $ordermodel->builder("vorder");
        $builder->select('COUNT(*) as trx');
        $builder->where('status_order', "open");
        $builder->where('tanggal_order >=', $now.' 00:00:00');
        $builder->where('tanggal_order <',  $now.' 23:59:59');
        $result = $builder->get()->getRow();
        if($result){
            $order_open = $result->trx;
        }

        $takeawaymodel = new Takeawaymodel();
        $builder = $takeawaymodel->builder("vtakeaway");
        $builder->select('COUNT(*) as trx');
        $builder->where('status', "open");
        $builder->where('tanggal >=', $now.' 00:00:00');
        $builder->where('tanggal <',  $now.' 23:59:59');
        $result = $builder->get()->getRow();
        if($result){
            $takeaway_open = $result->trx;
        }

        $mejamodel = new Mejamodel();
        $builder = $mejamodel->builder();
        $builder->select('COUNT(*) as meja');
        $builder->where('status', "kosong");
        $result = $builder->get()->getRow();
        if($result){
            $meja['kosong'] = $result->meja;
        }

        $mejamodel = new Mejamodel();
        $builder = $mejamodel->builder();
        $builder->select('COUNT(*) as meja');
        $builder->where('status', "terisi");
        $result = $builder->get()->getRow();
        if($result){
            $meja['terisi'] = $result->meja;
        }

        $belanjamodel = new Belanjamodel();
        $builder = $belanjamodel->builder("vbelanja");
        $builder->select('SUM(nominal) as total_nominal');
        $builder->where('tanggal',$now);
        $result = $builder->get()->getRow();
        $spend_today = $result->total_nominal;

        //die(var_dump($income));
        $data['income'] = $income;
        $data['order_open'] = $order_open;
        $data['takeaway_open'] = $takeaway_open;
        $data['meja'] = $meja;
        $data['spend_today'] = $spend_today;

        return view('admin/home/index',$data);
    }
}
