<?php
namespace App\Controllers;

use App\Models\Hargamodel;
use App\Models\Mejamodel;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use CodeIgniter\API\ResponseTrait;
use App\Models\Ordermodel;
use App\Models\Orderdetailmodel;
use App\Models\Pajakmodel;
use App\Models\Transaksimodel;

use Dompdf\Dompdf;
use Dompdf\Options;

class Transaksi extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index()
    {
        $data['user'] = $this->user->data;
        return view('admin/transaksi/index',$data);
    }

    public function ajax_dt(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Transaksimodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function view($id){
        $data['user'] = $this->user->data;
        $ordermodel = new Ordermodel();
        $builder = $ordermodel->builder("vorder");
        $data['order'] = $builder->where("id_order",$id)->get()->getRow();
        
        if(!$data['order']){
            die('<h4>Invalid Data!</h4>');
        }

        $orderdetailmodel = new Orderdetailmodel();
        $builder = $orderdetailmodel->builder("vorderdetail");
        $data['order_detail'] = $builder->where("id_order",$data['order']->id_order)->get()->getResult();

        return view('admin/transaksi/view',$data);
    }
}
?>