<?php
namespace App\Libraries;

class GeneralLib{
    public function getProfilePic($data)
    {
        if (!isset($data) || ($data==null))
        {
            return base_url().'uploads/user_profile/profile.png';
        }else{
            return base_url().'uploads/user_profile/'.$data;
        }
    }

    public function dt_traverse_search_builder($node)
    {
        $db = db_connect();
        $query_array = array();
        //$logic = $node['logic'];
        $logic = strtoupper($node['logic'] ?? 'AND');
        $logic = in_array($logic, ['AND','OR'], true) ? $logic : 'AND';
        
        $parts = [];
        $result_query = "";
        foreach($node['criteria'] as $item){
            if (isset($item['criteria']))
            {
                $child = $this->dt_traverse_search_builder($item);
                if ($child !== '') {
                    $parts[] = "($child)";
                }
                continue;
            }

            if (!isset($item['condition'], $item['origData'])) {
                continue;
            }

            $col   = $db->protectIdentifiers($item['origData']);
            $cond  = $item['condition'];
            $v1raw = $item['value1'] ?? '';
            $v2raw = $item['value2'] ?? '';

            // Escape untuk LIKE
            $v1 = $db->escapeLikeString($v1raw);
            $v2 = $db->escapeLikeString($v2raw);

            switch ($cond) {
                case 'starts':
                    $parts[] = "$col LIKE " . $db->escape($v1.'%') . " ESCAPE '!'";
                    break;
                case '!starts':
                    $parts[] = "$col NOT LIKE " . $db->escape($v1.'%') . " ESCAPE '!'";
                    break;
                case 'contains':
                    $parts[] = "$col LIKE " . $db->escape('%'.$v1.'%') . " ESCAPE '!'";
                    break;
                case '!contains':
                    $parts[] = "$col NOT LIKE " . $db->escape('%'.$v1.'%') . " ESCAPE '!'";
                    break;
                case 'ends':
                    $parts[] = "$col LIKE " . $db->escape('%'.$v1) . " ESCAPE '!'";
                    break;
                case '!ends':
                    $parts[] = "$col NOT LIKE " . $db->escape('%'.$v1) . " ESCAPE '!'";
                    break;
                case 'null':
                    // opsional: tambahkan OR $col='' hanya untuk kolom teks
                    $parts[] = "($col IS NULL OR $col = '')";
                    break;
                case 'between':
                    $v2 = ($v2raw === '') ? $v1 : $v2;
                    $parts[] = "($col BETWEEN " . $db->escape($v1raw) . " AND " . $db->escape($v2raw === '' ? $v1raw : $v2raw) . ")";
                    break;
                case '!between':
                    $v2 = ($v2raw === '') ? $v1 : $v2;
                    $parts[] = "($col NOT BETWEEN " . $db->escape($v1raw) . " AND " . $db->escape($v2raw === '' ? $v1raw : $v2raw) . ")";
                    break;
                default:
                    // Operator bebas (=, !=, >, <, >=, <=) — whitelist yang aman
                    $op = in_array($cond, ['=','!=','>','<','>=','<='], true) ? $cond : '=';
                    $parts[] = "$col $op " . $db->escape($v1raw);
                    break;
            }
        }

        if (empty($parts)) {
            return '';
        }

        return implode(" $logic ", $parts);
    }
}
?>