<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Belanja</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>belanja">Belanja</a></li>
        <li class="breadcrumb-item active" aria-current="page">Add</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>belanja" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <form name="f1" id="f1" action="<?=base_url()?>belanja/save_add" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Add New</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="tanggal" class="col-sm-3 col-form-label">Tanggal : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="tanggal" name="tanggal" value="<?=date('Y-m-d H:i:s')?>">
                            <span id="epersen" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="nominal" class="col-sm-3 col-form-label">Nominal : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="nominal" name="nominal" value="0">
                            <span id="epersen" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="keterangan" class="col-sm-3 col-form-label">Keterangan : </label>
                        <div class="col-sm-9">
                            <textarea class="form-control" id="keterangan" name="keterangan"></textarea>
                            <span id="epersen" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?= $this->include('layout/js/jquerymask') ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
flatpickr("#tanggal", {
  enableTime: true,
  dateFormat: "Y-m-d", // langsung cocok dengan MySQL DATETIME
  defaultDate: new Date(),
});
</script>

<script type="text/javascript">
$(document).ready(function() {
$('#nominal').mask("#,##0.00", {reverse: true});

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    $("#nominal").val($("#nominal").val().replaceAll(",",""));
    var data_kirim = $("#f1").serializeArray();

    $.post("<?=base_url()?>belanja/add_save",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data baru berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>belanja';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>
<?= $this->endSection() ?>