<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Harga</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>harga">Harga</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>harga/detail/<?=$produk->id_produk?>"><?=$produk->kode_nama_produk?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Add</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>harga/detail/<?=$produk->id_produk?>" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <form name="f1" id="f1" action="<?=base_url()?>harga/save_add" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Add New</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="harga_modal" class="col-sm-3 col-form-label">Harga Modal : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="harga_modal" name="harga_modal" value="0">
                            <span id="eharga_modal" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="harga_jual" class="col-sm-3 col-form-label">Harga Jual : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="harga_jual" name="harga_jual" value="0">
                            <span id="eharga_jual" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="aktif" class="col-sm-3 col-form-label">Status : </label>
                        <div class="col-sm-9">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="aktif" id="aktif" value="aktif" checked="checked">
                                <label class="form-check-label" for="gridRadios1"> Aktif </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="aktif" id="aktif" value="tidak aktif" checked="">
                                <label class="form-check-label" for="gridRadios1"> Tidak Aktif </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Detail Produk</h4>
            </div>
            <div class="card-body">
                <table class="table">
                    <tr>
                        <td>Kategori</td><td>:</td>
                        <td><b><?=$produk->kategori?></b></td>
                    </tr>
                    <tr>
                        <td>Kode / Nama</td><td>:</td>
                        <td><b><?=$produk->kode_nama_produk?></b></td>
                    </tr>
                    <tr>
                        <td>Created At</td><td>:</td>
                        <td><b><?=$produk->created_at?></b></td>
                    </tr>
                    <tr>
                        <td>Updated At</td><td>:</td>
                        <td><b><?=$produk->updated_at?></b></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?= $this->include('layout/js/jquerymask') ?>

<script type="text/javascript">
$(document).ready(function() {
$('#harga_modal').mask("#,##0.00", {reverse: true});
$('#harga_jual').mask("#,##0.00", {reverse: true});

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    $("#harga_modal").val($("#harga_modal").val().replaceAll(",",""));
    $("#harga_jual").val($("#harga_jual").val().replaceAll(",",""));
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id_produk", value : "<?=$produk->id_produk?>"});

    $.post("<?=base_url()?>harga/add_save",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data baru berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>harga/detail/<?=$produk->id_produk?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>
<?= $this->endSection() ?>