<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Dashboard</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?php
  helper('esc');
  $rupiah = fn($n) => 'Rp'.number_format((int)($n??0),0,',','.');
  $d = $income['channel']['ditempat'] ?? ['total'=>0,'count'=>0];
  $t = $income['channel']['takeaway'] ?? ['total'=>0,'count'=>0];
  $cash = $income['payment']['cash'] ?? ['total'=>0,'count'=>0];
  $qris = $income['payment']['qris'] ?? ['total'=>0,'count'=>0];
  $tf   = $income['payment']['transfer'] ?? ['total'=>0,'count'=>0];
  $totalIncome = ($d['total']??0) + ($t['total']??0); // atau array_sum payment
?>

<div class="row">
    <div class="col-lg-12 mb-3">
        Welcome!
    </div>
    <div class="col-12 col-lg-4 mb-3">
        <div class="card h-100">
            <div class="card-header bg-primary text-light">Pengguna</div>
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="rounded-circle bg-secondary-subtle d-inline-flex justify-content-center align-items-center me-3" style="width:56px;height:56px;">
                        <span class="fw-bold">U</span>
                    </div>
                    <div>
                        <h5 class="card-title mb-0"><?= esc($user->nama ?? 'Operator') ?></h5>
                    </div>
                </div>
                <div>
                    <small class="text-muted">Level : <?= esc($user->level ?? 'Kasir') ?></small>
                </div>
                <div>
                    <small class="text-muted">Last Login : <?= esc($user->last_login ?? '-') ?></small>
                </div>
                <div class="d-grid gap-2 mt-3">
                    <a href="<?=base_url()?>order" class="btn btn-primary touch">+ Order</a>
                    <a href="<?=base_url()?>takeaway" class="btn btn-outline-secondary touch">+ Takeaway</a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-lg-8 mb-3">
      <div class="card h-100">
        <div class="card-header bg-success text-light d-flex justify-content-between align-items-center">
          <span>Penerimaan Hari Ini</span>
          <span class="badge text-bg-primary">Total: <?= $rupiah($totalIncome) ?></span>
        </div>
        <div class="card-body">
          <!-- Baris atas: Channel + Ringkasan Operasional -->
          <div class="row g-3 mb-3">
            <!-- Per Channel -->
            <div class="col-12 col-xl-8">
              <div class="row g-3">
                <div class="col-12 col-md-6">
                  <div class="border rounded p-3 h-100">
                    <div class="d-flex justify-content-between align-items-center">
                      <span class="fw-semibold">Order Ditempat</span>
                      <span class="badge text-bg-success"><?= (int)$d['count'] ?> trx</span>
                    </div>
                    <div class="display-6 mt-2"><?= $rupiah($d['total']) ?></div>
                    <small class="text-muted">
                      Rata-rata: <?= $rupiah(($d['count']??0) ? ($d['total']/$d['count']) : 0) ?>
                    </small>
                    <div>
                        <a href="<?=base_url()?>order/riwayat" class="btn btn-outline-primary btn-sm">Lihat Riwayat</a>
                    </div>
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="border rounded p-3 h-100">
                    <div class="d-flex justify-content-between align-items-center">
                      <span class="fw-semibold">Takeaway</span>
                      <span class="badge text-bg-info"><?= (int)$t['count'] ?> trx</span>
                    </div>
                    <div class="display-6 mt-2"><?= $rupiah($t['total']) ?></div>
                    <small class="text-muted">
                      Rata-rata: <?= $rupiah(($t['count']??0) ? ($t['total']/$t['count']) : 0) ?>
                    </small>
                    <div>
                        <a href="<?=base_url()?>takeaway/riwayat" class="btn btn-outline-primary btn-sm">Lihat Riwayat</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Ringkasan Operasional: Order Open, Takeaway Open, Meja -->
            <div class="col-12 col-xl-4">
              <div class="border rounded p-3 h-100">
                <div class="d-flex justify-content-between">
                  <span class="fw-semibold">Order Open (Ditempat)</span>
                  <a href="<?=base_url()?>order" class="badge text-bg-warning"><?= (int)($order_open ?? 0) ?></a>
                </div>
                <div class="d-flex justify-content-between mt-2">
                  <span class="fw-semibold">Takeaway Open</span>
                  <a href="<?=base_url()?>takeaway" class="badge text-bg-warning"><?= (int)($takeaway_open ?? 0) ?></a>
                </div>
                <hr>
                <div class="d-flex justify-content-between">
                  <span class="fw-semibold">Meja Terisi</span>
                  <span class="badge text-bg-danger"><?= (int)($meja['terisi'] ?? 0) ?></span>
                </div>
                <div class="d-flex justify-content-between mt-2">
                  <span class="fw-semibold">Meja Kosong</span>
                  <span class="badge text-bg-success"><?= (int)($meja['kosong'] ?? 0) ?></span>
                </div>
              </div>
            </div>
          </div>

          <!-- Baris bawah: Metode Pembayaran -->
          <h6 class="mb-2">Per Metode Pembayaran</h6>
          <div class="row g-3">
            <div class="col-12 col-md-4">
              <div class="border rounded p-3 h-100">
                <div class="fw-semibold">Cash</div>
                <div class="fs-3 mt-2"><?= $rupiah($cash['total']) ?></div>
                <small class="text-muted"><?= (int)$cash['count'] ?> trx</small>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <div class="border rounded p-3 h-100">
                <div class="fw-semibold">QRIS</div>
                <div class="fs-3 mt-2"><?= $rupiah($qris['total']) ?></div>
                <small class="text-muted"><?= (int)$qris['count'] ?> trx</small>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <div class="border rounded p-3 h-100">
                <div class="fw-semibold">Transfer</div>
                <div class="fs-3 mt-2"><?= $rupiah($tf['total']) ?></div>
                <small class="text-muted"><?= (int)$tf['count'] ?> trx</small>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>

    <!-- Belanja Hari Ini -->
    <div class="col-12 col-lg-6">
      <div class="card h-100">
        <div class="card-header bg-danger text-light">Belanja Hari Ini</div>
        <div class="card-body">
          <div class="display-5"><?= $rupiah($spend_today ?? 0) ?></div>
          <small class="text-muted d-block">Catatan: bahan baku, gas, dll.</small>
          <div class="mt-3">
            <a href="<?=base_url()?>belanja" class="btn btn-outline-secondary btn-sm">Detail Belanja</a>
            <a href="<?=base_url()?>belanja/add" class="btn btn-outline-primary btn-sm">Input Belanja</a>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-6">
      <div class="card h-100">
        <div class="card-header bg-primary text-light">Balance Hari Ini</div>
        <div class="card-body">
          <div class="display-5"><?= $rupiah(($totalIncome - $spend_today) ?? 0) ?></div>
          <small class="text-muted d-block">Catatan: Penerimaan - Belanja.</small>
        </div>
      </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->endSection() ?>