<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Laporan</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
            <li class="breadcrumb-item"><a href="<?= base_url() ?>">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Laporan</li>
            <li class="breadcrumb-item active" aria-current="page">Keuangan</li>
            <li class="breadcrumb-item active" aria-current="page">Laba Rugi</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row g-4">
    <div class="col-lg-8">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white py-2">
                <h5 class="mb-0">
                    <i class="bi bi-file-earmark-text"></i> Laporan Laba Rugi
                </h5>
            </div>

            <div class="card-body">
                <!-- Satu form; action diubah dinamis via jQuery -->
                <form id="frmLabaRugi" method="GET" target="_blank">
                    <div class="row g-3">
                        <!-- Start Date -->
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">
                                <i class="bi bi-calendar-event"></i> Tanggal Mulai
                            </label>
                            <input type="date" name="start" class="form-control" required>
                        </div>

                        <!-- End Date -->
                        <div class="col-md-6">
                            <label class="form-label fw-semibold">
                                <i class="bi bi-calendar-check"></i> Tanggal Selesai
                            </label>
                            <input type="date" name="end" class="form-control" required>
                        </div>

                        <!-- Actions -->
                        <div class="col-12 mt-3 d-flex gap-2 flex-wrap">
                            <button type="button"
                                    class="btn btn-primary"
                                    id="btnLabaPdf"
                                    data-action="<?= base_url('laporan/laba_rugi_proses') // atau ganti ke .../laba_rugi_pdf jika pakai route itu ?>">
                                <i class="bi bi-printer me-1"></i> Cetak PDF
                            </button>

                            <button type="button"
                                    class="btn btn-success"
                                    id="btnLabaExcel"
                                    data-action="<?= base_url('laporan/laba_rugi_proses_excel') ?>">
                                <i class="bi bi-file-earmark-excel me-1"></i> Download Excel
                            </button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>
<script>
$(function(){
    function validTanggal(){
        const s = $('[name="start"]').val();
        const e = $('[name="end"]').val();
        if (!s || !e) {
            if (typeof Swal !== 'undefined') {
                Swal.fire('Tanggal belum lengkap','Isi tanggal mulai & selesai dulu ya.','warning');
            } else {
                alert('Isi tanggal mulai & selesai dulu ya.');
            }
            return false;
        }
        return true;
    }

    $('#btnLabaPdf, #btnLabaExcel').on('click', function(){
        if (!validTanggal()) return;
        $('#frmLabaRugi').attr('action', $(this).data('action')).trigger('submit');
    });
});
</script>
<?= $this->endSection() ?>
