<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Meja</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>meja">Meja</a></li>
        <li class="breadcrumb-item active" aria-current="page">Add</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>meja" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>meja/save_add" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Add New</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="nama_meja" class="col-sm-2 col-form-label">Nama Meja : </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="nama_meja" name="nama_meja">
                            <span id="enama_meja" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="flag" class="col-sm-2 col-form-label">Flag : </label>
                        <div class="col-sm-10">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="flag" id="flag" value="aktif" checked="checked">
                                <label class="form-check-label" for="gridRadios1"> Aktif </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="flag" id="flag" value="tidak aktif" checked="">
                                <label class="form-check-label" for="gridRadios1"> Tidak Aktif </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>
<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    var data_kirim = $("#f1").serialize();

    $.post("<?=base_url()?>meja/add_save",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data baru berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>meja/add';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>
<?= $this->endSection() ?>