<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Pajak</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>pajak">Pajak</a></li>
        <li class="breadcrumb-item active" aria-current="page">View</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>pajak" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
        <a href="#" id="btn_delete" class="btn btn-sm btn-danger btn-icon"><i class="button-icon bi bi-trash"></i> <span>Delete Data</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <form name="f1" id="f1" action="<?=base_url()?>pajak/update" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">View</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="persen" class="col-sm-3 col-form-label">Persen : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="persen" name="persen" value="<?=$data->persen?>">
                            <span id="epersen" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="status" class="col-sm-3 col-form-label">Status : </label>
                        <div class="col-sm-9">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status" value="aktif" <?=($data->status=='aktif') ? "checked" : "" ?>>
                                <label class="form-check-label" for="gridRadios1"> Aktif </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="status" id="status" value="tidak aktif" <?=($data->status=='tidak aktif') ? "checked" : "" ?>>
                                <label class="form-check-label" for="gridRadios1"> Tidak Aktif </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?= $this->include('layout/js/jquerymask') ?>

<script type="text/javascript">
$(document).ready(function() {
$('#persen').mask("##.##", {reverse: false});

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    $("#persen").val($("#persen").val().replaceAll(",",""));
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id", value : "<?=$data->id_pajak?>"});

    $.post("<?=base_url()?>pajak/update",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>pajak/view/<?=$data->id_pajak?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

$("#btn_delete").click(function(e) {
    e.preventDefault();

    Swal.fire({
        title:'Delete Data..',
        html: '<p>Yakin ingin menghapus data ini?</p>',
        showDenyButton: true,
        showCancelButton: true,
        confirmButtonText: 'Yes',
        denyButtonText: 'No',
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                text: 'Menghapus data.. Silahkan tunggu..',
                allowOutsideClick: false
            });
            Swal.showLoading();
            $.post("<?=base_url()?>pajak/delete",{id:<?=$data->id_pajak?>}).done(function (data) {
                if (data.status == 'success')
                {
                    Swal.fire({
                        text:'Data berhasil dihapus!',
                        icon : 'success'
                    }).then(function () {
                        window.location.href = '<?=base_url()?>pajak';
                    });
                }
            }).fail(function (data) {
                Swal.fire({
                    text:'Terjadi kesalahan pada saat operasi delete!',
                    icon : 'error'
                });
            });
        } else if (result.isDenied) {
            Swal.fire('Operasi dibatalkan..', '', 'info')
        }
    });
});
});
</script>
<?= $this->endSection() ?>