<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Produk</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Produk</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row g-4">
    <div class="col-lg-12">
        <table id="tbl1" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Nama</th>
                    <th class="dt-filterable">Kategori</th>
                    <th class="dt-filterable">Status</th>
                    <th class="dt-filterable">Gambar</th>
                    <th class="dt-filterable">Updated At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/datatables') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>produk/ajax_dt',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode_produk' },
            { data: 'nama_produk' },
            { data: 'kategori' },
            { data: 'status' },
            { data: 'gambar',
                searchable : false,
                orderable : false,
                render: function (data, type, row) {
                    if (type === 'display') {
                    // validasi agar tidak error jika kosong
                    if (!data) return '<span class="text-muted">Tidak ada gambar</span>';
                    return `<img src="<?=base_url()?>gambar/${data}" alt="${row.nama_produk}" width="100" style="object-fit:cover;border-radius:8px;">`;
                    }
                    return data; // untuk export atau filter
                }
             },
             { data: 'updated_at' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 7,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> View</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            {
                text: '<span class="fas fa-plus"> Add New</span>',
                action: function ( e, dt, node, config ) {
                    document.location.href="<?=base_url()?>produk/add";
                }
            },
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>produk/view/'+data['id_produk'];
    });
});
</script>
<?= $this->endSection() ?>