<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Akun Pengguna</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Profile</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>profile/update" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Profile</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="email" class="col-sm-2 col-form-label">Email : </label>
                        <div class="col-sm-10">
                            <input type="email" class="form-control" id="email" name="email" value="<?=$data->email?>">
                            <span id="eemail" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="username" class="col-sm-2 col-form-label">Nama : </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="username" name="username" value="<?=$data->nama?>">
                            <span id="eusername" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="flag" class="col-sm-2 col-form-label">Level : </label>
                        <div class="col-sm-10">
                            <select name="group" class="form-control select2">
                                <option value="<?=$data->level?>" selected><?=$data->level?></option>
                                <option value="admin">Admin</option>
                                <option value="operator">Operator</option>
                                <option value="waiter">Waiter</option>
                            </select>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="password" class="col-sm-2 col-form-label">Password : </label>
                        <div class="col-sm-10">
                            <input type="password" class="form-control" id="password" name="password">
                            <span id="epassword" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <hr class="input_separator"/>
                    <div class="row mb-3">
                        <label for="password_confirm" class="col-sm-2 col-form-label">Password Confirm : </label>
                        <div class="col-sm-10">
                            <input type="password" class="form-control" id="password_confirm" name="password_confirm">
                            <span id="epassword_confirm" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex gap-2">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?= $this->include('layout/css/select2') ?>
<?= $this->include('layout/js/select2') ?>

<script type="text/javascript">
$(document).ready(function() {

$(".select2").select2({
    theme: 'bootstrap-5'
});

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    var data_kirim = $("#f1").serializeArray();

    $.post("<?=base_url()?>profile/update",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>profile';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>
<?= $this->endSection() ?>