<?= $this->extend('layout/main') ?>

<?= $this->section('content_header') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Takeaway</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Takeaway</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3 g-4">
    <div class="col-lg-12">
        
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h1 class="card-title h4 mb-0">Pilih Takeaway</h1>
                <a href="<?=base_url()?>takeaway/add" class="btn btn-primary touch">+ Tambah Takeaway</a>
            </div>
            <div class="card-body">
                <div class="row g-3 g-md-4">
                    <?php foreach($takeaway as $t): 
                        $statusClass = ($t->status === 'open') ? 'status-kosong' : 'status-terisi';
                        $statusText  = ucfirst($t->status); // Kosong / Terisi
                        $url         = base_url('takeaway/pesanan/'.$t->id_takeaway);
                    ?>
                    <div class="col-4 col-md-3 col-lg-2">
                        <a href="<?= $url; ?>" class="table-tile <?= $statusClass; ?>"
                            data-status="<?= esc($t->status); ?>"
                            aria-label="Takeaway <?= esc($t->nama); ?>, status <?= esc($statusText); ?>">
                            <div class="d-flex">
                                <div class="tile-content d-flex flex-column justify-content-center align-items-center w-100">
                                <div class="table-name"><?= esc($t->nama); ?></div>
                                <span class="status-badge rounded-pill"><?= esc($statusText); ?></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <?php
                    endforeach;
                    ?>
                </div>
            </div>
        </div>
    </div>
    
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>

<?= $this->endSection() ?>