<!doctype html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>POS | Login Page</title>
        <!--begin::Primary Meta Tags-->
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="title" content="POS | Login Page" />
        <!--end::Primary Meta Tags-->
        <!--begin::Fonts-->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fontsource/source-sans-3@5.0.12/index.css" integrity="sha256-tXJfXfp6Ewt1ilPzLDtQnJV4hclT9XuaZUKyUvmyr+Q=" crossorigin="anonymous" />
        <!--end::Fonts-->
        <!--begin::Third Party Plugin(OverlayScrollbars)-->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.10.1/styles/overlayscrollbars.min.css" integrity="sha256-tZHrRjVqNSRyWg2wbppGnT833E/Ys0DHWGwT04GiqQg=" crossorigin="anonymous" />
        <!--end::Third Party Plugin(OverlayScrollbars)-->
        <!--begin::Third Party Plugin(Bootstrap Icons)-->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" integrity="sha256-9kPW/n5nn53j4WMRYAxe9c1rCY96Oogo/MKSVdKzPmI=" crossorigin="anonymous" />
        <!--end::Third Party Plugin(Bootstrap Icons)-->
        
        <link rel="stylesheet" href="<?=base_url()?>theme/css/adminlte.css" />
        <style>
            body{
                background:
                    linear-gradient(rgba(255,255,255,.9), rgba(255,255,255,1)), /* layer gelap 35% */
                    url('assets/bg.jfif') center / cover no-repeat fixed; /* gambar penuh */
            }
        </style>
    </head>
    <body class="login-page bg-body-primary d-flex flex-sm-column flex-md-row gap-5">
        <div class="d-flex flex-column gap-2 align-items-center h-100 justify-content-center">
            <img src="<?=base_url()?>assets/logo_kemendiktisaintek.png" width="100">
            <span style="font-size: 14px; text-align:center;"><b>Program Pengabdian kepada Masyarakat (PkM)<br/>Kementerian Pendidikan Tinggi, Sains, dan Teknologi (Kemdiktisaintek) <br/>2025</b></span>
        </div>
        <div class="login-box">
            <div class="card">
                <div class="card-body login-card-body">
                    <div class="login-logo">
                        <img src="<?=base_url()?>assets/logo_retfin.png" height="50">
                    </div>
                    <p class="login-box-msg">Sign in to start your session</p>
                    <?php if (session('error') !== null) : ?>
                        <div class="alert alert-danger" role="alert"><?= session('error') ?></div>
                    <?php elseif (session('errors') !== null) : ?>
                        <div class="alert alert-danger" role="alert">
                            <?php if (is_array(session('errors'))) : ?>
                                <?php foreach (session('errors') as $error) : ?>
                                    <?= $error ?>
                                    <br>
                                <?php endforeach ?>
                            <?php else : ?>
                                <?= session('errors') ?>
                            <?php endif ?>
                        </div>
                    <?php endif ?>
                    <?php if (session('message') !== null) : ?>
                        <div class="alert alert-success" role="alert"><?= session('message') ?></div>
                    <?php endif ?>
                    <form action="<?= url_to('login') ?>" method="post">
                        <div class="input-group mb-3">
                            <input type="email" class="form-control" name="email" placeholder="Email" />
                            <div class="input-group-text"><span class="bi bi-envelope"></span></div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="password" class="form-control" name="password" placeholder="Password" />
                            <div class="input-group-text"><span class="bi bi-lock-fill"></span></div>
                        </div>
                        <div class="row">
                            <div class="col-8">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" <?php if (old('remember')): ?> checked<?php endif ?> id="flexCheckDefault" />
                                    <label class="form-check-label" for="flexCheckDefault"> Remember Me </label>
                                </div>
                            </div>
                            <!-- /.col -->
                            <div class="col-4">
                                <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">Sign In</button>
                                </div>
                            </div>
                            <!-- /.col -->
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </body>
</html>