<?php
function rupiah($n){ return 'Rp'.number_format((int)$n,0,',','.'); }
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title><?=esc($title)?></title>
<style>
@page { size: A4 portrait; margin: 14mm 16mm; }
body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 11px; color:#000; }
h2,h3 { margin:0 0 6px; }
.small{ font-size:10px; } .right{text-align:right;} .bold{font-weight:700;}
table{ width:100%; border-collapse:collapse; }
.kv td{ padding:6px 6px; vertical-align:top; }
.hr{ border-top:1px solid #000; margin:8px 0; }
</style>
</head>
<body>

<table>
  <tr>
    <td>
      <h2><?=esc($title)?></h2>
      <div class="small">Periode: <?=esc($rangeText)?></div>
    </td>
    <td class="right small">Dicetak: <?=esc($printedAt)?></td>
  </tr>
</table>

<div class="hr"></div>

<h3 style="margin:0 0 8px;">Ringkasan</h3>
<table class="kv">
  <tr>
    <td>Penjualan Kotor (sebelum pajak & diskon)</td>
    <td class="right" style="width:160px;"><?= rupiah($penjualanKotor) ?></td>
  </tr>
  <tr>
    <td>Diskon</td>
    <td class="right"><?= rupiah($totalDiskon) ?></td>
  </tr>
  <tr>
    <td>Pajak</td>
    <td class="right"><?= rupiah($totalPajak) ?></td>
  </tr>
  <tr>
    <td class="bold">Omzet (Grand Total)</td>
    <td class="right bold"><?= rupiah($omzetGrand) ?></td>
  </tr>
</table>

<h3 style="margin:16px 0 6px;">Perhitungan Laba Rugi</h3>
<table class="kv">
  <tr>
    <td>Penjualan Kotor</td>
    <td class="right" style="width:160px;"><?= rupiah($penjualanKotor) ?></td>
  </tr>
  <tr>
    <td>HPP / COGS</td>
    <td class="right">- <?= rupiah($cogs) ?></td>
  </tr>
  <tr>
    <td class="bold">Laba Kotor</td>
    <td class="right bold"><?= rupiah($labaKotor) ?></td>
  </tr>
  <tr>
    <td>Biaya Operasional</td>
    <td class="right">- <?= rupiah($biayaOperasional) ?></td>
  </tr>
  <tr>
    <td class="bold">Laba Bersih</td>
    <td class="right bold"><?= rupiah($labaBersih) ?></td>
  </tr>
</table>

<h3 style="margin:16px 0 6px;">Rasio</h3>
<table class="kv">
  <tr>
    <td>Gross Margin</td>
    <td class="right"><?= number_format($grossMarginPct,1,',','.') ?>%</td>
  </tr>
  <tr>
    <td>Net Margin</td>
    <td class="right"><?= number_format($netMarginPct,1,',','.') ?>%</td>
  </tr>
</table>

<!-- <div class="small" style="margin-top:16px; color:#444;">
  Catatan:
  <ul>
    <li>Penjualan Kotor diambil dari <em>total_jual</em> (sebelum pajak & diskon).</li>
    <li>Omzet (Grand Total) = total_jual − diskon + pajak.</li>
    <li>HPP / COGS diambil dari Σ <strong>total_modal</strong> pada <em>vtransaksi</em> dan <em>vtransaksitakeaway</em>.</li>
    <li>Biaya Operasional diambil dari Σ <em>vbelanja.nominal</em> pada periode.</li>
  </ul>
</div> -->

</body>
</html>
