<?php
function rupiah($n){ return 'Rp'.number_format((int)$n,0,',','.'); }
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title><?=esc($title)?></title>
<style>
@page { size: A4 portrait; margin: 12mm 14mm; }
body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 11px; color:#000; }
h2,h3 { margin:0 0 6px; }
.small{ font-size:10px; } .right{text-align:right;} .center{text-align:center;} .bold{font-weight:700;}
table{ width:100%; border-collapse:collapse; }
th,td{ padding:6px 6px; border:1px solid #000; vertical-align:top; }
thead{ display:table-header-group; }
tfoot{ display:table-row-group; }
tr{ page-break-inside:avoid; }
.hr{ border-top:1px solid #000; margin:8px 0; }
</style>
</head>
<body>

<!-- Header -->
<table>
  <tr>
    <td>
      <h2><?=esc($title)?></h2>
      <div class="small">Periode: <?=esc($rangeText)?></div>
    </td>
    <td class="right small">Dicetak: <?=esc($printedAt)?></td>
  </tr>
</table>

<div class="hr"></div>

<!-- Detail Belanja -->
<h3 style="margin:0 0 8px 0;">Detail Pengeluaran</h3>
<table class="small">
  <thead class="bold">
    <tr>
      <th style="width:40px;">No</th>
      <th style="width:120px;">Tanggal</th>
      <th>Keterangan</th>
      <th style="width:150px;">Operator</th>
      <th style="width:120px;" class="right">Nominal</th>
    </tr>
  </thead>
  <tbody>
    <?php if (empty($rows)): ?>
      <tr><td colspan="5" class="center">Tidak ada pengeluaran pada periode ini.</td></tr>
    <?php else: $no=1; foreach($rows as $r): ?>
      <tr>
        <td class="center"><?=$no++?></td>
        <td><?=date('d/m/Y H:i', strtotime($r['tanggal']))?></td>
        <td><?=esc($r['keterangan'])?></td>
        <td><?=esc($r['nama'] ?? '-')?></td>
        <td class="right"><?=rupiah($r['nominal'])?></td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
  <tfoot class="bold">
    <tr>
      <td colspan="4" class="right">TOTAL PENGELUARAN</td>
      <td class="right"><?=rupiah($totalBelanja)?></td>
    </tr>
  </tfoot>
</table>

<!-- Ringkasan per Operator -->
<h3 style="margin:16px 0 8px 0;">Ringkasan per Operator</h3>
<table class="small">
  <thead class="bold">
    <tr>
      <th>Operator</th>
      <th style="width:120px;" class="right">Jumlah Transaksi</th>
      <th style="width:130px;" class="right">Total Nominal</th>
    </tr>
  </thead>
  <tbody>
    <?php if (empty($ops)): ?>
      <tr><td colspan="3" class="center">-</td></tr>
    <?php else: foreach($ops as $o): ?>
      <tr>
        <td><?=esc($o['nama_operator'] ?? '-')?></td>
        <td class="right"><?= (int)$o['jml'] ?></td>
        <td class="right"><?= rupiah($o['total']) ?></td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
  <tfoot class="bold">
    <tr>
      <td class="right">TOTAL</td>
      <td class="right"><?= (int)$totalTransaksi ?></td>
      <td class="right"><?= rupiah($totalBelanja) ?></td>
    </tr>
  </tfoot>
</table>

</body>
</html>
