<?php
function rupiah($n){ return 'Rp'.number_format((int)$n,0,',','.'); }
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title><?=esc($title)?></title>
<style>
@page { size: A4 landscape; margin: 10mm 12mm; }

body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 11px; }
h2,h3 { margin:0 0 6px; }

table { width:100%; border-collapse: collapse; }
th,td { padding: 6px 6px; border:1px solid #000; }

.center{text-align:center;}
.right{text-align:right;}
.bold{font-weight:bold;}
.small{font-size:10px;}

thead { display: table-header-group; }
tfoot { display: table-row-group; }
tr { page-break-inside: avoid; }

.hr { border-top:1px solid #000; margin:8px 0; }
</style>
</head>
<body>

<!-- Header -->
<table>
<tr>
    <td>
        <h2><?=esc($title)?></h2>
        <div class="small">Periode: <?=esc($rangeText)?></div>
    </td>
    <td class="right small">
        Dicetak: <?=esc($printedAt)?>
    </td>
</tr>
</table>

<div class="hr"></div>

<!-- Table -->
<table class="small">
<thead class="bold">
<tr>
    <th style="width:40px;">No</th>
    <th style="width:120px;">Tanggal</th>
    <th style="width:80px;">Kode</th>
    <th style="width:80px;">Meja</th>
    <th style="width:90px;" class="right">Total</th>
    <th style="width:90px;" class="right">Diskon</th>
    <th style="width:90px;" class="right">Pajak</th>
    <th style="width:110px;" class="right">Grand Total</th>
    <th style="width:90px;">Metode</th>
</tr>
</thead>

<tbody>
<?php if(empty($trx)): ?>
<tr><td colspan="9" class="center">Tidak ada data transaksi pada periode ini.</td></tr>
<?php else: $no=1; foreach($trx as $t): ?>
<tr>
    <td class="center"><?=$no++?></td>
    <td><?=date('d/m/Y', strtotime($t['tanggal_order']))?></td>
    <td><?=esc($t['kode_order'])?></td>
    <td><?=esc($t['nama_meja'])?></td>
    <td class="right"><?=rupiah($t['total_jual'])?></td>
    <td class="right"><?=rupiah($t['diskon_total'])?></td>
    <td class="right"><?=rupiah($t['pajak_nominal'])?></td>
    <td class="right"><?=rupiah($t['grand_total'])?></td>
    <td><?=strtoupper($t['metode'])?></td>
</tr>
<?php endforeach; endif; ?>
</tbody>

<tfoot class="bold">
<tr>
    <td colspan="4" class="right">TOTAL</td>
    <td class="right"><?=rupiah($sumTotalD)?></td>
    <td class="right"><?=rupiah($sumDiskonD)?></td>
    <td class="right"><?=rupiah($sumPajakD)?></td>
    <td class="right"><?=rupiah($sumGrandD)?></td>
    <td></td>
</tr>
</tfoot>
</table>

<div class="hr"></div>

<!-- Table -->
<table class="small">
<thead class="bold">
<tr>
    <th style="width:40px;">No</th>
    <th style="width:120px;">Tanggal</th>
    <th style="width:80px;">Kode</th>
    <th style="width:80px;">Customer</th>
    <th style="width:90px;" class="right">Total</th>
    <th style="width:90px;" class="right">Diskon</th>
    <th style="width:90px;" class="right">Pajak</th>
    <th style="width:110px;" class="right">Grand Total</th>
    <th style="width:90px;">Metode</th>
</tr>
</thead>

<tbody>
<?php if(empty($trxT)): ?>
<tr><td colspan="9" class="center">Tidak ada data transaksi takeaway pada periode ini.</td></tr>
<?php else: $no=1; foreach($trxT as $t): ?>
<tr>
    <td class="center"><?=$no++?></td>
    <td><?=date('d/m/Y', strtotime($t['tanggal']))?></td>
    <td><?=esc($t['kode_takeaway'])?></td>
    <td><?=esc($t['nama'])?></td>
    <td class="right"><?=rupiah($t['total_jual'])?></td>
    <td class="right"><?=rupiah($t['diskon_total'])?></td>
    <td class="right"><?=rupiah($t['pajak_nominal'])?></td>
    <td class="right"><?=rupiah($t['grand_total'])?></td>
    <td><?=strtoupper($t['metode'])?></td>
</tr>
<?php endforeach; endif; ?>
</tbody>

<tfoot class="bold">
<tr>
    <td colspan="4" class="right">TOTAL</td>
    <td class="right"><?=rupiah($sumTotalT)?></td>
    <td class="right"><?=rupiah($sumDiskonT)?></td>
    <td class="right"><?=rupiah($sumPajakT)?></td>
    <td class="right"><?=rupiah($sumGrandT)?></td>
    <td></td>
</tr>
</tfoot>
</table>

<!-- ===== RINGKASAN LAPORAN (Ditempat vs Takeaway) ===== -->
<h3 style="margin:16px 0 8px 0;">Ringkasan Laporan</h3>

<table style="width:100%; border-collapse:collapse; font-size:11px;">
  <tbody>
    <tr>
      <td style="padding:6px;">Total Transaksi Dine-In</td>
      <td style="padding:6px; text-align:right;"><?= (int)$countD ?> trx</td>
      <td style="padding:6px;">Omzet Dine-In (Grand Total)</td>
      <td style="padding:6px; text-align:right; font-weight:bold;"><?= rupiah($sumGrandD) ?></td>
    </tr>
    <tr>
      <td style="padding:6px;">Total Transaksi Takeaway</td>
      <td style="padding:6px; text-align:right;"><?= (int)$countT ?> trx</td>
      <td style="padding:6px;">Omzet Takeaway (Grand Total)</td>
      <td style="padding:6px; text-align:right; font-weight:bold;"><?= rupiah($sumGrandT) ?></td>
    </tr>

    <tr><td colspan="4" style="border-top:1px solid #000;"></td></tr>

    <tr>
      <td style="padding:6px;">TOTAL TRANSAKSI</td>
      <td style="padding:6px; text-align:right; font-weight:bold;"><?= (int)$countAll ?> trx</td>
      <td style="padding:6px;"><strong>TOTAL OMZET (Grand Total)</strong></td>
      <td style="padding:6px; text-align:right; font-weight:bold;"><?= rupiah($omzetAll) ?></td>
    </tr>

    <tr>
      <td style="padding:6px;">Total Pajak</td>
      <td style="padding:6px; text-align:right;"><?= rupiah($totalPajakAll) ?></td>
      <td style="padding:6px;">Total Diskon</td>
      <td style="padding:6px; text-align:right;"><?= rupiah($totalDiskonAll) ?></td>
    </tr>

    <tr><td colspan="4" style="border-top:1px solid #000;"></td></tr>

    <tr>
      <td style="padding:6px;">Penjualan Kotor (sebelum pajak & diskon)</td>
      <td style="padding:6px; text-align:right;"><?= rupiah($penjualanKotorAll) ?></td>
      <td style="padding:6px;">Penjualan Bersih (Grand Total)</td>
      <td style="padding:6px; text-align:right; font-weight:bold;"><?= rupiah($omzetAll) ?></td>
    </tr>

    <tr><td colspan="4" style="border-top:1px solid #000;"></td></tr>

    <tr>
      <td style="padding:6px;">Rata-rata Tiket Dine-In</td>
      <td style="padding:6px; text-align:right;"><?= rupiah(round($avgTicketD)) ?></td>
      <td style="padding:6px;">Rata-rata Tiket Takeaway</td>
      <td style="padding:6px; text-align:right;"><?= rupiah(round($avgTicketT)) ?></td>
    </tr>
    <tr>
      <td style="padding:6px;">Rata-rata Tiket (Semua)</td>
      <td style="padding:6px; text-align:right; font-weight:bold;"><?= rupiah(round($avgTicketAll)) ?></td>
      <td></td><td></td>
    </tr>
  </tbody>
</table>

</body>
</html>
