<?php
function rupiah($n){ return 'Rp'.number_format((int)$n,0,',','.'); }
$labels = ['cash' => 'CASH', 'qris' => 'QRIS', 'debit' => 'DEBIT', 'lainnya' => 'LAINNYA'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title><?=esc($title)?></title>
<style>
@page { size: A4 landscape; margin: 12mm 14mm; }
body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 11px; color:#000; }
h2,h3 { margin:0 0 6px; }
.small{ font-size:10px; } .right{text-align:right;} .center{text-align:center;} .bold{font-weight:700;}
table{ width:100%; border-collapse:collapse; }
th,td{ padding:6px 6px; border:1px solid #000; vertical-align:top; }
thead{ display:table-header-group; }
tfoot{ display:table-row-group; }
tr{ page-break-inside:avoid; }
.hr{ border-top:1px solid #000; margin:8px 0; }
</style>
</head>
<body>

<!-- Header -->
<table>
  <tr>
    <td>
      <h2><?=esc($title)?></h2>
      <div class="small">Periode: <?=esc($rangeText)?></div>
    </td>
    <td class="right small">Dicetak: <?=esc($printedAt)?></td>
  </tr>
</table>

<div class="hr"></div>

<!-- Tabel Ringkasan -->
<table class="small">
  <thead class="bold">
    <tr>
      <th style="width:140px;">Metode</th>
      <th style="width:120px;" class="right">Dine-In (Nominal)</th>
      <th style="width:95px;"  class="right">Dine-In (Trx)</th>
      <th style="width:120px;" class="right">Takeaway (Nominal)</th>
      <th style="width:95px;"  class="right">Takeaway (Trx)</th>
      <th style="width:130px;" class="right">TOTAL Nominal</th>
      <th style="width:95px;"  class="right">TOTAL Trx</th>
      <th style="width:90px;"  class="right">% Share</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($methods as $m): ?>
      <tr>
        <td class="bold"><?= $labels[$m] ?></td>
        <td class="right"><?= rupiah($summary[$m]['d_nominal']) ?></td>
        <td class="right"><?= (int)$summary[$m]['d_count'] ?></td>
        <td class="right"><?= rupiah($summary[$m]['t_nominal']) ?></td>
        <td class="right"><?= (int)$summary[$m]['t_count'] ?></td>
        <td class="right bold"><?= rupiah($summary[$m]['total_nominal']) ?></td>
        <td class="right"><?= (int)$summary[$m]['total_count'] ?></td>
        <td class="right"><?= number_format($summary[$m]['percent'], 1, ',', '.') ?>%</td>
      </tr>
    <?php endforeach; ?>
  </tbody>
  <tfoot class="bold">
    <tr>
      <td class="right">TOTAL</td>
      <td class="right"><?= rupiah($totals['d_nominal']) ?></td>
      <td class="right"><?= (int)$totals['d_count'] ?></td>
      <td class="right"><?= rupiah($totals['t_nominal']) ?></td>
      <td class="right"><?= (int)$totals['t_count'] ?></td>
      <td class="right"><?= rupiah($totals['total_nominal']) ?></td>
      <td class="right"><?= (int)$totals['total_count'] ?></td>
      <td class="right">100,0%</td>
    </tr>
  </tfoot>
</table>

</body>
</html>
