<?php
$base_mm   = 100;                 // header + tabel total + footer (perkiraan)
$per_row   = 6;                  // tinggi rata-rata per item (mm)
$n_items   = isset($items) ? count($items) : 0;
$paper_h   = $base_mm + $n_items * $per_row;

// clamp (biar tidak terlalu pendek/terlalu panjang)
$paper_h   = max(58, min($paper_h, 300)); // min 58mm, max 300mm

function rupiah($n){ return 'Rp'.number_format((int)$n,0,',','.'); }
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Struk <?=$order['kode']??''?></title>
<style>
  @page { size: 58mm <?=$paper_h?>mm; margin:0; }
  html,body { margin:0; padding:0; }
  body { font-family: DejaVu Sans, Arial, sans-serif; font-size:11px; line-height:1.25; color:#000; }
  .wrap { width:52mm; margin:0 auto; padding:6px; }
  .center{text-align:center;} .right{text-align:right;}
  .hr{border-top:1px dashed #000;margin:6px 0;}
  .small{font-size:10px;} .bold{font-weight:700;}
  table{width:100%;border-collapse:collapse;}
  td{padding:2px 0;vertical-align:top;}
  .col-nama{width:58%;} .col-qty{width:17%;text-align:center;} .col-sub{width:25%;text-align:right;}
  .grand td{font-weight:700;border-top:1px dashed #000;border-bottom:1px dashed #000;padding:4px 0;}
</style>
</head>
<body>
  <div class="wrap">

    <div class="center bold">STRUK PEMBAYARAN</div>
    <div class="hr"></div>

    <div class="small">
      <div class="kv"><span>Kode : </span><span class="right"><?=$order['kode']??'-'?></span></div>
      <div class="kv"><span>Tanggal : </span><span class="right"><?=isset($order['tanggal'])?date('d/m/Y H:i',strtotime($order['tanggal'])):'-'?></span></div>
      <div class="kv"><span>Kasir : </span><span class="right"><?=$order['kasir']??'-'?></span></div>
      <div class="kv"><span>Nama : </span><span class="right"><?=$order['nama']??'-'?></span></div>
      <div class="kv"><span>Metode : </span><span class="right"><?=strtoupper($order['metode']??'-')?></span></div>
    </div>

    <div class="hr"></div>

    <table>
      <thead>
        <tr class="bold">
          <td class="col-nama">Item</td><td class="col-qty">Qty</td><td class="col-sub">Subtotal</td>
        </tr>
      </thead>
      <tbody>
        <?php foreach($items as $it): ?>
        <tr>
          <td class="col-nama">
            <?=htmlspecialchars($it['nama'])?><br>
            <span class="small muted"><?= (int)$it['qty']?> × <?=rupiah($it['harga'])?></span>
          </td>
          <td class="col-qty"><?=$it['qty']?></td>
          <td class="col-sub"><?=rupiah($it['subtotal'])?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <div class="hr"></div>

    <table>
      <tr><td>Subtotal</td><td class="right"><?=rupiah($total['subtotal']??0)?></td></tr>
      <?php if(($total['diskon']??0)!=0):?><tr><td>Diskon</td><td class="right">-<?=rupiah($total['diskon'])?></td></tr><?php endif;?>
      <?php if(($total['pajak']??0)!=0):?><tr><td>Pajak</td><td class="right"><?=rupiah($total['pajak'])?></td></tr><?php endif;?>
      <tr class="grand"><td>Total</td><td class="right"><?=rupiah($total['grand_total']??$total['subtotal']??0)?></td></tr>
      <?php if(isset($order['dibayar'])):?>
      <tr><td>Bayar</td><td class="right"><?=rupiah($order['dibayar'])?></td></tr>
      <tr><td>Kembali</td><td class="right"><?=rupiah($order['kembali']??max(0,($order['dibayar']??0)-($total['grand_total']??0)))?></td></tr>
      <?php endif;?>
    </table>

    <div class="hr"></div>

    <div class="center small">
      Terima kasih telah berbelanja<br>
      <span>Dicetak: <?=date('d/m/Y H:i')?></span>
    </div>

  </div>
</body>
</html>
